/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import java.util.Arrays;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class Sort
extends AbstractNativeCodeSequence {
    public static void sortFloatArray8Reverse() {
        int addr = Sort.getGprA0();
        int size = Sort.getGprA1();
        if (size < 2) {
            return;
        }
        Object[] objects = new Float8ObjectReverse[size];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, size << 3, 4);
        for (int i = 0; i < size; ++i) {
            objects[i] = new Float8ObjectReverse(memoryReader);
        }
        Arrays.sort(objects);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, size << 3, 4);
        for (int i = 0; i < size; ++i) {
            ((Float8ObjectReverse)objects[i]).write(memoryWriter);
        }
        memoryWriter.flush();
    }

    private static class Float8ObjectReverse
    implements Comparable<Float8ObjectReverse> {
        private int n1;
        private int n2;
        private float f;

        public Float8ObjectReverse(IMemoryReader memoryReader) {
            this.n1 = memoryReader.readNext();
            this.n2 = memoryReader.readNext();
            this.f = Float.intBitsToFloat(this.n2);
        }

        public void write(IMemoryWriter memoryWriter) {
            memoryWriter.writeNext(this.n1);
            memoryWriter.writeNext(this.n2);
        }

        @Override
        public int compareTo(Float8ObjectReverse o) {
            return Float.compare(o.f, this.f);
        }
    }
}

